<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Boleta de Pago</title>
    
    <link rel="stylesheet" href="<?php echo e(public_path('css/app.css')); ?>" type="text/css" />
</head>

<body>
    <div class="container">
        <div class="content-header">
            <div class="logo">
                <br />
                <img src="<?php echo e(public_path('images/logo-sin-fondo.png')); ?>" alt="Logo de la empresa">
                <br />
                <br />         
            </div>
            <div class="header">
                <br />
                <strong>Cotización: </strong><span><?php echo e($venta[0]->numeroContizacion); ?></span><br/>
                <strong>Fecha de Creación: </strong><span><?php echo e(\Carbon\Carbon::parse($venta[0]->fechaCreacion)->format('d/m/Y')); ?></span><br/>
                <strong>Hora: </strong><span><?php echo e(\Carbon\Carbon::parse($venta[0]->fechaCreacion)->format('H:i:s')); ?></span><br/>
            </div>
        </div>

        <div class="customer-info">
            <h4>INFORMACIÓN DEL CLIENTE</h4>
            <table>
                <tr>
                    <td class="customer-info-key"><span>Actividad n°:</span></td>
                    <td class="customer-info-value"><span><?php echo e($venta[0]->descripcionActividad); ?></span></td>
                </tr>
                <tr>
                    <td class="customer-info-key"><span>Tipo de actividad n°:</span></td>
                    <td class="customer-info-value">
                        <span><?php echo e(!empty($venta[0]->codigoActividad) ? $venta[0]->codigoActividad : ''); ?></span>
                    </td>
                </tr>
                <tr>
                    <td class="customer-info-key"><span>Contrato n°:</span></td>
                    <td class="customer-info-value"><span><?php echo e($venta[0]->numeroContrato); ?></span></td>
                </tr>
                <tr>
                    <td class="customer-info-key"><span>Nombre cliente:</span></td>
                    <td class="customer-info-value"><?php echo e($venta[0]->nombreCliente); ?></td>
                </tr>
                <tr>
                    <td class="customer-info-key"><span>Dirección de instalación:</span></td>
                    <td class="customer-info-value"><?php echo e($venta[0]->direccionInstalacion); ?></td>
                </tr>
                <tr>
                    <td class="customer-info-key"><span>Código de postal:</span></td>
                    <td class="customer-info-value"><?php echo e($venta[0]->codigoPostalDirInstalacion); ?></td>
                </tr>
                <tr>
                    <td class="customer-info-key"><span>Localidad:</span></td>
                    <td class="customer-info-value"><?php echo e($venta[0]->localidadDirInstalacion); ?></td>
                </tr>
            </table>
        </div>

        <div class="customer-cotizacion">
            <h4>COTIZACIÓN</h4>
            <table>
                
                <?php

                // $IsVenta = collect($ventaDetalle)
                // ->where('idTipoModalidadProducto', Prosegur\Core\Core\Constante\TipoModalidadProducto::Venta)
                // ->count() > 0 ? "X" : "";

                // $IsInterConexion = collect($ventaDetalle)
                // ->where('idTipoModalidadProducto', Prosegur\Core\Core\Constante\TipoModalidadProducto::Interconexion)
                // ->count() > 0 ? "X" : "";

                // $IsRenting = collect($ventaDetalle)
                // ->where('idTipoModalidadProducto', Prosegur\Core\Core\Constante\TipoModalidadProducto::Renting)
                // ->count() > 0 ? "X" : "";
                ?>
                <tr>
                    

                </tr>
                <tr>
                    <td class="customer-info-key"><span>Planes:</td>
                    <td class="customer-info-span">&nbsp; RSI </td><input type="checkbox">
                    <td class="customer-info-span">&nbsp; NEO </td><input type="checkbox">
                    <td class="customer-info-span">&nbsp; GPRS </td><input type="checkbox">
                    <td class="customer-info-span">&nbsp; Contigo </td><input type="checkbox">

                </tr>
                <tr>
                    <td class="customer-info-key"><span>Renovación:</td>
                    <td class="customer-info-span">&nbsp; Video </td><input type="checkbox">
                    <td class="customer-info-span">&nbsp; CCTV </td><input type="checkbox">
                    <td class="customer-info-span">&nbsp; Acuda </td><input type="checkbox">

                </tr>

                <?php
                $isAfiliacionSi = $venta[0]->afiliacionDebito ? "X" : "";
                $isAfiliacionNo = !$venta[0]->afiliacionDebito ? "X" : "";
                $plazoRenovar = empty($venta[0]->renovacionContrato) ? "" : $venta[0]->renovacionContrato . " Meses";

                ?>
                <tr>
                    <td class="customer-info-key"><span>Afiliación al débito:</td>
                    <td class="customer-info-span">&nbsp; Si </td><input type="checkbox" value="<?php echo e($isAfiliacionSi); ?>">
                    <td class="customer-info-span">&nbsp; No </td><input type="checkbox" value="<?php echo e($isAfiliacionNo); ?>">
                    <td class="customer-info-span">&nbsp; Plazo a renovar </td><input type="checkbox"
                        value="<?php echo e($plazoRenovar); ?>">
                </tr>
            </table>

        </div>

        <div class="payment-details">
            <h4>EQUIPOS Y/O SERVICIOS NO RECURRENTES</h4>
            <table class="table-products">
                <thead class="thead-products">
                    <tr>
                        <th>DESCRIPCIÓN</th>
                        <th>CANTIDAD</th>
                        <th>P.UNIT</th>
                        <th>% DSCTO</th>
                        <th>PRECIO TOTAL</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $ventaDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                    $sumaDsct = $detalle->descuentoProducto + $detalle->descuentoAdicional;
                    $sumaTotalIgv = $detalle->subTotal + $detalle->igv;
                    ?>

                    <tr>
                        <td class="tbody-tr-left"><?php echo e($detalle->descripcionOracle); ?></td>
                        <td class="tbody-tr-left"><?php echo e($detalle->cantidad); ?></td>
                        <td class="tbody-tr-rigth"><?php echo e($sumaTotalIgv); ?></td>
                        <td class="tbody-tr-rigth"> % <?php echo e(intval($sumaDsct)); ?></td>
                        <td class="tbody-tr-rigth"><?php echo e($detalle->precioVenta); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <?php
                    $priceSum = 0;

                    foreach ($ventaDetalle as $productInCart) {
                    $priceSum += $productInCart->precioVenta;
                    }

                    $priceSum += $venta[0]->totalVentaNbo2_7000M;
                    ?>

                    <tr class="tfoot-services">
                        <td colspan="4" class="tfoot-services-total">TOTAL (IGV)</td>
                        <td class="tfoot-services-soles">S/. <?php echo e($priceSum); ?></td>
                    </tr>
                </tfoot>
            </table>
            
            <h4>SERVICIOS RECURRENTES</h4>
            <?php if( $venta[0]->totalRecurrente  > 0): ?>
    
            <table class="table-products">
                <thead class="thead-products">
                    <tr>
                        <th class="tbody-tr-rigth">Total Nuevo Recurrente Monitoreo - Renovación 36 meses</th>
                    </tr>
                </thead>
                <tfoot>
                
                    <tr class="tfoot-services">
                        <td class="tbody-tr-rigth">S/. <?php echo e($venta[0]->totalRecurrente); ?></td>
                    </tr>
                </tfoot>
            </table>
            
            <?php else: ?>
          
                <table class="table-products">
                    <thead class="thead-products">
                        <tr>
                            <th>DESCRIPCIÓN</th>
                            <th>CANTIDAD</th>
                            <th>P.TOTAL</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $ventaDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>              
                    <tr>
                        <td class="tbody-tr-left"><?php echo e($detalle->descripcionOracle); ?></td>
                        <td class="tbody-tr-left"><?php echo e($detalle->cantidad); ?></td>
                        <td class="tbody-tr-rigth"><?php echo e($detalle->recurrenteSubtotal); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody> 
                </table>
            <?php endif; ?>

            
            <?php
           $recurrenteDetail = collect($ventaDetalle)->max('precioVentaRecurrente');
            ?>

            <?php if($recurrenteDetail > 0): ?>
            
            <table class="table-products">
                <thead class="thead-products">
                    <tr>
                        <th>DESCRIPCIÓN</th>
                        <th>CANTIDAD</th>
                        <th>P.UNIT</th>
                        <th>% DSCTO</th>
                        <th>PRECIO TOTAL</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $ventaDetalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($detalle->recurrenteSubtotal > 0): ?>
                    <tr>
                        <td class="tbody-tr-left"><?php echo e($detalle->descripcionOracle); ?></td>
                        <td><?php echo e($detalle->cantidad); ?></td>
                        <td><?php echo e($detalle->precioVentaRecurrente); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr class="tfoot-services">
                        <th style="width: 25%;">% DSCT</th>
                        <td style="width: 40%;">% nnnnnnnsns <?php echo e(intval($venta->porcentajeDescuentoRecurrenteAdicional)); ?> </td>
                        <th style="width: 25%;">TOTAL INCRE.MENSUAL</th>
                        <td style="width: 40%;"><?php echo e($venta->totalRecurrente); ?> </td>
                    </tr>


                </tfoot>
            </table>

            <?php endif; ?>
        </div>
        <div class="footer">
            <div class="footer-msg-title">
                <h4>Para el descuento otorgado sea válido, el cliente deberá estar al día en sus pagos</h4>
            </div>
            <br />
            <div class="footer-cotizador">
                <div class="nombre-cotizador">
                    <span><?php echo e($venta[0]->nombres); ?></span>
                    <hr>
                    <span>Nombre Cotizador</span>
                </div>
                <div class="firma-cotizador">
                    <span>?</span>
                    <hr>
                    <span>Firma Cotizador</span>
                </div>
                <div class="autorizacion-cotizador">
                    <span>?</span>
                    <hr>
                    <span>Firma del cliente o persona autorizada</span>
                </div>
            </div>


            <br />
            <br />
            <br />
            <br />
            <span class="footer-span">Lima: Av. República de Panamá Nº 3890, Telf.: (01) 513­8686 ­ Surquillo /
                Trujillo: Av. Salvador Lara
                Nº 1193­1195 Urb. Miraflores, Telf.: (044) 29­3939 / Arequipa: Ca. María
                Nieves y Bustamante 101 Urb. La Quinta ­ Umacollo, Telf.: (054) 24­7590 Piura: Carretera Piura Sullana
                Km. 3.5, Telf.: (073) 33­3190 ­ Piura / Chiclayo: Block 5A1 Residencial
                Pascual Saco , Telf.: (074) 27­3074
            </span>
        </div>
    </div>
</body>

</html><?php /**PATH C:\Proyectos\PROSEGUR\admin-prosegur\resources\views/reports/budget.blade.php ENDPATH**/ ?>