import { ref, inject } from 'vue'

export default function useBtcs2() {
    const formsBtc2 = ref({
        codigoCliente: [],
        numeroContrato: '',
        CodigoTipoPanel: '',
        porcentajeDescuento: '',
        puntosRecurrente: '',
        TipoPanel: '',
        descripcionOracle: [],
        codigoActividadInmueble: '',
        porcentajeDescuento: 0
    })
    const btc2List = ref([]);
    const contratosList = ref([]);

    // NUEVO
    const clientesList = ref([]);
    const modalidadesList = ref([]);
    const modalidadesFiltered = ref([]);
    const campanasList = ref([]);
    const campanasDetailsProductList = ref([]);
    const campanasDetailsServiceList = ref([]);

    const swal = inject('$swal');
    const toast = inject('$toast');

    const getBtcs2 = async () => {
        try {
            const response = await axios.get(`${window.appUrl}/api/btc2s`);
            btc2List.value = response.data.data;
            // console.log("->>>>");
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }

    const getContratos = async (paramOptional) => {
        try {
            const response = await axios.get(`${window.appUrl}/api/getContratos?param=` + paramOptional);
            // console.log(response.data.data);
            contratosList.value = response.data.data;
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }

    const getCampanasByClient = async (paramCodCLient) => {
        try {
            const response = await axios.get(`${window.appUrl}/api/getCampanasByCliente?codCLient=` + paramCodCLient);
            // console.log(response.data);
            campanasList.value = response.data;
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }

    const getDetailsCampanasProduct = async (prmCodigoCliente,prmIdCampana) => {
        try {
            const response = await axios.get(`${window.appUrl}/api/getDetailsCampanasProduct?prmCodigoCliente=` + prmCodigoCliente + `&prmIdCampana=` + prmIdCampana);
            // console.log(response.data);
            response.data.forEach(item => {
                item.quantity = 1;
                item.chkStatusNbo = false;
            });
            campanasDetailsProductList.value = response.data;
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }

    
    const getDetailsCampanasService = async (prmCodigoCliente,prmIdCampana) => {
        try {
            const response = await axios.get(`${window.appUrl}/api/getDetailsCampanasService?prmCodigoCliente=` + prmCodigoCliente + `&prmIdCampana=` + prmIdCampana);
            // console.log(response.data);
            response.data.forEach(item => {
                item.quantity = 1;
                item.chkStatusNbo = false;
            });
            campanasDetailsServiceList.value = response.data;
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }



    const getBtcs2ByCodRegimen = async (codRegimen) => {
        try {
            const response = await axios.get(`${window.appUrl}/api/getAllCodRegimen/` + codRegimen);
            formsBtc2.value = response.data.data[0];
            // console.log(response.data.data);
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }

    //NUEVOS
    const getClientes = async (valor, queryParams) => {
        try {
            const response = await axios.get(`${window.appUrl}/api/getAllClientes?busqueda=` + valor);
            clientesList.value = response.data;
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }

    const getContratoByNumero = async (numero, perfil) => {
        try {
            const response = await axios.get(`${window.appUrl}/api/getContratoByNumero?numeroContrato=` + numero + '&idCategoriaPerfil=' + perfil);
            formsBtc2.value = response.data ?? {};
            // console.log(formsBtc2.value);
            // console.log(response.data);
            if (!response.data) {
                swal({
                    icon: 'warning',
                    title: 'Contrato no encontrado',
                    showConfirmButton: false,
                    timer: 1500
                })
            }

        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }

    const getModalidades = async (perfil) => {
        try {
            const response = await axios.get(`${window.appUrl}/api/getModalidades?idCategoriaPerfil=` + perfil);
            // console.log(response.data);
            modalidadesList.value = response.data;
        } catch (error) {
            console.error("Ha ocurrido un error:", error);
        }
    }

    return {
        toast,
        campanasList,
        campanasDetailsProductList,
        campanasDetailsServiceList,
        formsBtc2,
        btc2List,
        clientesList,
        contratosList,
        modalidadesList,
        modalidadesFiltered, 
        getBtcs2,
        getContratos,
        getBtcs2ByCodRegimen,
        getClientes,
        getContratoByNumero,
        getModalidades,
        getCampanasByClient,
        getDetailsCampanasProduct,
        getDetailsCampanasService
    }
}
