<?php

namespace Database\Seeders;

use App\Models\ProductoDetalle;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ProductoDetalleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        ProductoDetalle::create([
            'id' => 'valor_id_1',
            'moneda' => 'S', 
            'idProducto' => 'valor_idProducto_1',
            'idTipoModalidadProducto' => 'valor_idTipoModalidadProducto_1',
            'subTotal' => 100.00,
            'igv' => 18.00,
            'precioVenta' => 118.00,
            'fechaCreacion' => now(),
            'usuarioModificador' => null,
            'fechaModificacion' => null,
            'estado' => true,
            'usuarioCreador' => 1,
        ]);

        ProductoDetalle::create([
            'id' => 'valor_id_2',
            'moneda' => 'D', 
            'idProducto' => 'valor_idProducto_2',
            'idTipoModalidadProducto' => 'valor_idTipoModalidadProducto_2',
            'subTotal' => 80.50,
            'igv' => 14.49,
            'precioVenta' => 95.99,
            'fechaCreacion' => now(),
            'usuarioModificador' => null,
            'fechaModificacion' => null,
            'estado' => true,
            'usuarioCreador' => 2,
        ]);

        ProductoDetalle::create([
            'id' => 'valor_id_3',
            'moneda' => 'S',
            'idProducto' => 'valor_idProducto_3',
            'idTipoModalidadProducto' => 'valor_idTipoModalidadProducto_3',
            'subTotal' => 55.75,
            'igv' => 10.04,
            'precioVenta' => 65.79,
            'fechaCreacion' => now(),
            'usuarioModificador' => null,
            'fechaModificacion' => null,
            'estado' => false,
            'usuarioCreador' => 3,
        ]);
    }
}
