<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('socio', function (Blueprint $table) {
            $table->string('id',64);
            $table->string('idTipoSocio',64);
            $table->string('idDocumentoIdentidad',64)->nullable();
            $table->string('numeroDocumento',20)->nullable();
            $table->string('nombres',500)->nullable();
            $table->string('direccion',900)->nullable();
            $table->string('telefono',50)->nullable();
            $table->string('sexo',20)->nullable();
            $table->string('correo',500)->nullable();
            $table->integer('usuarioCreador',);
            $table->datetime('fechaCreacion');
            $table->integer('usuarioModificador',)->nullable();
            $table->datetime('fechaModificacion')->nullable();
            $table->boolean('estado');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('socio');
    }
};
