<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('Venta', function (Blueprint $table) {
            $table->string('id',64);
            $table->string('numeroContrato',100);
            $table->string('idCliente',50)->nullable();
            $table->string('estadoVenta',1000)->nullable();
            $table->integer('usuarioCreador',);
            $table->datetime('fechaCreacion');
            $table->integer('usuarioModificador',)->nullable();
            $table->datetime('fechaModificacion')->nullable();
            $table->boolean('estado');
            $table->string('observacion',500)->nullable();
            $table->string('ultimoVenta',64)->nullable();
            $table->string('nombreCliente',500)->nullable();
            $table->string('observacionRechazo',1000)->nullable();
            $table->string('renovacionContrato',20)->nullable();
            $table->boolean('upgrade')->nullable();
            $table->boolean('afiliacionDebito')->nullable();
            $table->string('codigoActividad',200)->nullable();
            $table->string('DescripcionActividad',200)->nullable();
            $table->decimal('porcentajeDescuentoRecurrenteAdicional',10,2)->nullable();
            $table->decimal('totalRecurrente',10,2)->nullable();
            $table->integer('numeroContizacion',);
            $table->string('idVentaMigracion',64)->nullable();
            $table->decimal('costoInstalacion',8,2)->nullable();
            $table->decimal('totalVentaNbo2_7000M',10,2)->nullable();    
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('venta');
    }
};
