<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('productodetalle', function (Blueprint $table) {
            $table->string('id',64);
            $table->char('moneda',1);
            $table->string('idProducto',64);
            $table->string('idTipoModalidadProducto',64);
            $table->decimal('subTotal',8,2);
            $table->decimal('igv',8,2);
            $table->decimal('precioVenta',8,2);
            $table->datetime('fechaCreacion');
            $table->integer('usuarioModificador',)->nullable();
            $table->datetime('fechaModificacion')->nullable();
            $table->boolean('estado');
            $table->integer('usuarioCreador',);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('productodetalle');
    }
};
