<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('producto', function (Blueprint $table) {
            $table->string('id',64);
            $table->string('descripcionTipoProducto',900);
            $table->string('codigoSiebel',100)->nullable();
            $table->string('descripcionSiebel',2000)->nullable();
            $table->string('codigoOracle',900)->nullable();
            $table->string('descripcionOracle',2000)->nullable();
            $table->string('codigoGsmart',100)->nullable();
            $table->decimal('recurrenteSubtotal',8,2);
            $table->decimal('recurrenteTotal',8,2);
            $table->integer('usuarioCreador',);
            $table->datetime('fechaCreacion');
            $table->integer('usuarioModificador',)->nullable();
            $table->datetime('fechaModificacion')->nullable();
            $table->boolean('estado');
            $table->string('tipoPanel',200)->nullable();
            $table->boolean('flagProductoEspecial')->nullable();
            $table->string('marca',200)->nullable();
            $table->decimal('recurrenteHogar',8,2)->nullable();
            $table->decimal('recurrenteNegocio',8,2)->nullable();
            $table->boolean('esRecurrenteHogarNegocio')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('producto');
    }
};
