<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('btc2', function (Blueprint $table) {
            $table->string('id',64);
            $table->string('numeroContrato',100)->nullable();
            $table->string('codigoCliente',100)->nullable();
            $table->string('codigoConexion',100)->nullable();
            $table->string('nifCliente',100)->nullable();
            $table->string('nombre',100)->nullable();
            $table->text('codigoTipoContrato')->nullable();
            $table->text('respaldo')->nullable();
            $table->text('normativaContrato')->nullable();
            $table->text('codigoRegimen')->nullable();
            $table->datetime('fechaInstalacion')->nullable();
            $table->datetime('fechaVencimiento')->nullable();
            $table->text('codigoEstado')->nullable();
            $table->text('clasificacionComercial')->nullable();
            $table->text('Churn_Rate_Clas_Com')->nullable();
            $table->text('metodoPago')->nullable();
            $table->text('segmentoCliente')->nullable();
            $table->text('responsableCliente')->nullable();
            $table->text('codigoActividadInmueble')->nullable();
            $table->text('codigoSubtipoLocal')->nullable();
            $table->text('paqueteComercial')->nullable();
            $table->text('CodigoTipoPanel')->nullable();
            $table->text('telfDireccionInstalacion')->nullable();
            $table->text('direccionInstalacion')->nullable();
            $table->text('localidadDirInstalacion')->nullable();
            $table->text('provinciaDirInstalacion')->nullable();
            $table->text('regionDirInstalacion')->nullable();
            $table->text('codigoPostalDirInstalacion')->nullable();
            $table->text('delegacionAdministrativa')->nullable();
            $table->text('correoCliente')->nullable();
            $table->text('emailNotificacion')->nullable();
            $table->text('motivoBaja')->nullable();
            $table->datetime('fechaBaja')->nullable();
            $table->decimal('totalRecurrente',10,2)->nullable();
            $table->integer('usuarioCreador',)->nullable();
            $table->datetime('fechaCreacion')->nullable();
            $table->text('TipoPanel',100)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('btc2');
    }
};
