<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DescuentoDetalle extends Model
{
    use HasFactory;
    protected $table = 'descuentodetalle';

    protected $fillable = [
        'id',
        'idCategoriaCliente',
        'idCategoriaPerfil',
        'porcentajeDescuento',
        'porcentajeDescuentoDeuda',
        'porcentajeDescuentoRobo',
        'usuarioCreador',
        'fechaCreacion',
        'usuarioModificador',
        'fechaModificacion',
        'estado',
        'idDescuento',
    ];

    protected $casts = [
        'porcentajeDescuento' => 'decimal:2',
        'porcentajeDescuentoDeuda' => 'decimal:2',
        'porcentajeDescuentoRobo' => 'decimal:2',
    ];
}
