<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProductoResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'descripcionTipoProducto' => $this->descripcionTipoProducto,
            'codigoSiebel' => $this->codigoSiebel,
            'descripcionSiebel' => $this->descripcionSiebel,
            'codigoOracle' => $this->codigoOracle,
            'descripcionOracle' => $this->descripcionOracle,
            'codigoGsmart' => $this->codigoGsmart,
            'recurrenteSubtotal' => $this->recurrenteSubtotal,
            'recurrenteTotal' => $this->recurrenteTotal,
            'usuarioCreador' => $this->usuarioCreador,
            'fechaCreacion' => $this->fechaCreacion,
            'usuarioModificador' => $this->usuarioModificador,
            'fechaModificacion' => $this->fechaModificacion,
            'estado' => $this->estado,
            'tipoPanel' => $this->tipoPanel,
            'flagProductoEspecial' => $this->flagProductoEspecial,
            'marca' => $this->marca,
            'recurrenteHogar' => $this->recurrenteHogar,
            'recurrenteNegocio' => $this->recurrenteNegocio,
            'esRecurrenteHogarNegocio' => $this->esRecurrenteHogarNegocio
            // 'created_at' => $this->created_at->toDateString()
        ];
    }
}
