<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Boleta de Pago</title>
    {{--
    <link rel="stylesheet" href="{{ public_path('css/bootstrap.css') }}" type="text/css" /> --}}
    <link rel="stylesheet" href="{{ public_path('css/app.css') }}" type="text/css" />
</head>

<body>
    <div class="container">
        <div class="content-header">
            <div class="logo">
                <br />
                <img src="{{public_path('images/logo-sin-fondo.png')}}" alt="Logo de la empresa">
                <br />
                <br />         
            </div>
            <div class="header">
                <br />
                <strong>Cotización: </strong><span>{{ $venta[0]->numeroContizacion }}</span><br/>
                <strong>Fecha de Creación: </strong><span>{{ \Carbon\Carbon::parse($venta[0]->fechaCreacion)->format('d/m/Y')}}</span><br/>
                <strong>Hora: </strong><span>{{ \Carbon\Carbon::parse($venta[0]->fechaCreacion)->format('H:i:s') }}</span><br/>
            </div>
        </div>

        <div class="customer-info">
            <h4>INFORMACIÓN DEL CLIENTE</h4>
            <table>
                 <!--<tr>
                    <td class="customer-info-key"><span>Actividad n°:</span></td>
                    <td class="customer-info-value"><span>{{ $venta[0]->descripcionActividad }}</span></td>
                </tr>
                <tr>
                    <td class="customer-info-key"><span>Tipo de actividad n°:</span></td>
                    <td class="customer-info-value">
                        <span>{{ !empty($venta[0]->codigoActividad) ? $venta[0]->codigoActividad : '' }}</span>
                    </td>
                </tr>-->
                <tr>
                    <td class="customer-info-key"><span>Contrato n°:</span></td>
                    <td class="customer-info-value"><span>{{ $venta[0]->numeroContrato }}</span></td>
                </tr>
                <tr>
                    <td class="customer-info-key"><span>Nombre cliente:</span></td>
                    <td class="customer-info-value">{{ $venta[0]->nombreCliente }}</td>
                </tr>
                <tr>
                    <td class="customer-info-key"><span>Dirección de instalación:</span></td>
                    <td class="customer-info-value">{{ $venta[0]->direccionInstalacion }}</td>
                </tr>
                <tr>
                    <td class="customer-info-key"><span>Código de postal:</span></td>
                    <td class="customer-info-value">{{ $venta[0]->codigoPostalDirInstalacion }}</td>
                </tr>
                <tr>
                    <td class="customer-info-key"><span>Localidad:</span></td>
                    <td class="customer-info-value">{{ $venta[0]->localidadDirInstalacion }}</td>
                </tr>
            </table>
        </div>

        <!--<div class="customer-cotizacion">
            <h4>COTIZACIÓN</h4>
            <table>
                {{-- <p>{{ json_encode( $ventaDetalle[0])}}</p> --}}
                @php

                // $IsVenta = collect($ventaDetalle)
                // ->where('idTipoModalidadProducto', Prosegur\Core\Core\Constante\TipoModalidadProducto::Venta)
                // ->count() > 0 ? "X" : "";

                // $IsInterConexion = collect($ventaDetalle)
                // ->where('idTipoModalidadProducto', Prosegur\Core\Core\Constante\TipoModalidadProducto::Interconexion)
                // ->count() > 0 ? "X" : "";

                // $IsRenting = collect($ventaDetalle)
                // ->where('idTipoModalidadProducto', Prosegur\Core\Core\Constante\TipoModalidadProducto::Renting)
                // ->count() > 0 ? "X" : "";
                @endphp
                <tr>
                    {{-- <td class="customer-info-key"><span>Modaliad:</span></td>
                    <td class="customer-info-span">&nbsp; Venta </td><input type="checkbox" value="{{$IsVenta}}">
                    <td class="customer-info-span">&nbsp; Cesión</td><input type="checkbox"
                        value="{{$IsInterConexion}}">
                    <td class="customer-info-span">&nbsp; Interconexión</span></td><input type="checkbox"
                        value="{{$IsRenting}}">
                    <td class="customer-info-span">&nbsp; Arrendamiento</td> <input type="checkbox">
                    --}}

                </tr>
                <tr>
                    <td class="customer-info-key"><span>Planes:</td>
                    <td class="customer-info-span">&nbsp; RSI </td><input type="checkbox">
                    <td class="customer-info-span">&nbsp; NEO </td><input type="checkbox">
                    <td class="customer-info-span">&nbsp; GPRS </td><input type="checkbox">
                    <td class="customer-info-span">&nbsp; Contigo </td><input type="checkbox">

                </tr>
                <tr>
                    <td class="customer-info-key"><span>Renovación:</td>
                    <td class="customer-info-span">&nbsp; Video </td><input type="checkbox">
                    <td class="customer-info-span">&nbsp; CCTV </td><input type="checkbox">
                    <td class="customer-info-span">&nbsp; Acuda </td><input type="checkbox">

                </tr>

                @php
                $isAfiliacionSi = $venta[0]->afiliacionDebito ? "X" : "";
                $isAfiliacionNo = !$venta[0]->afiliacionDebito ? "X" : "";
                $plazoRenovar = empty($venta[0]->renovacionContrato) ? "" : $venta[0]->renovacionContrato . " Meses";

                @endphp
                <tr>
                    <td class="customer-info-key"><span>Afiliación al débito:</td>
                    <td class="customer-info-span">&nbsp; Si </td><input type="checkbox" value="{{$isAfiliacionSi}}">
                    <td class="customer-info-span">&nbsp; No </td><input type="checkbox" value="{{$isAfiliacionNo}}">
                    <td class="customer-info-span">&nbsp; Plazo a renovar </td><input type="checkbox"
                        value="{{$plazoRenovar}}">
                </tr>
            </table>

        </div>-->

        <div class="payment-details">
            <h4>EQUIPOS Y/O SERVICIOS NO RECURRENTES</h4>
            <table class="table-products">
                <thead class="thead-products">
                    <tr>
                        <th>DESCRIPCIÓN</th>
                        <th>CANTIDAD</th>
                        <th>P.UNIT</th>
                        <th>% DSCTO</th>
                        <th>PRECIO TOTAL</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($ventaDetalle as $detalle)
                    @php
                    $sumaDsct = $detalle->descuentoProducto + $detalle->descuentoAdicional;
                    $sumaTotalIgv = $detalle->subTotal + $detalle->igv;
                    @endphp

                    <tr>
                        <td class="tbody-tr-left">{{ $detalle->descripcionOracle }}</td>
                        <td class="tbody-tr-left">{{ $detalle->cantidad }}</td>
                        <td class="tbody-tr-rigth">{{ $sumaTotalIgv }}</td>
                        <td class="tbody-tr-rigth"> % {{ intval($sumaDsct) }}</td>
                        <td class="tbody-tr-rigth">{{ $detalle->precioVenta }}</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    @php
                    $priceSum = 0;

                    foreach ($ventaDetalle as $productInCart) {
                    $priceSum += $productInCart->precioVenta;
                    }

                    $priceSum += $venta[0]->totalVentaNbo2_7000M;
                    @endphp

                    <tr class="tfoot-services">
                        <td colspan="4" class="tfoot-services-total">TOTAL (IGV)</td>
                        <td class="tfoot-services-soles">S/. {{ $priceSum }}</td>
                    </tr>
                </tfoot>
            </table>
            {{-- if recurrente total > 0 --}}
            <h4>SERVICIOS RECURRENTES</h4>
            @if ( $venta[0]->totalRecurrente  > 0)
    {{-- total nuevo reccurente 36 meses... --}}
            <table class="table-products">
                <thead class="thead-products">
                    <tr>
                        <th class="tbody-tr-rigth">Total Nuevo Recurrente Monitoreo - Renovación 36 meses</th>
                    </tr>
                </thead>
                <tfoot>
                
                    <tr class="tfoot-services">
                        <td class="tbody-tr-rigth">S/. {{ $venta[0]->totalRecurrente  }}</td>
                    </tr>
                </tfoot>
            </table>
            {{-- else --}}
            @else
          
                <table class="table-products">
                    <thead class="thead-products">
                        <tr>
                            <th>DESCRIPCIÓN</th>
                            <th>CANTIDAD</th>
                            <th>P.TOTAL</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($ventaDetalle as $detalle)              
                    <tr>
                        <td class="tbody-tr-left">{{ $detalle->descripcionOracle }}</td>
                        <td class="tbody-tr-left">{{ $detalle->cantidad }}</td>
                        <td class="tbody-tr-rigth">{{ $detalle->recurrenteSubtotal }}</td>
                    </tr>
                    @endforeach
                    </tbody> 
                </table>
            @endif

            {{-- RECURRENTE --}}
            @php
           $recurrenteDetail = collect($ventaDetalle)->max('precioVentaRecurrente');
            @endphp

            @if ($recurrenteDetail > 0)
            {{-- <h4>EQUIPOS Y/O SERVICIOS NO RECURRENTES</h4> --}}
            <table class="table-products">
                <thead class="thead-products">
                    <tr>
                        <th>DESCRIPCIÓN</th>
                        <th>CANTIDAD</th>
                        <th>P.UNIT</th>
                        <th>% DSCTO</th>
                        <th>PRECIO TOTAL</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($ventaDetalle as $detalle)
                    @if ($detalle->recurrenteSubtotal > 0)
                    <tr>
                        <td class="tbody-tr-left">{{ $detalle->descripcionOracle }}</td>
                        <td>{{ $detalle->cantidad }}</td>
                        <td>{{ $detalle->precioVentaRecurrente }}</td>
                    </tr>
                    @endif
                    @endforeach
                </tbody>
                <tfoot>
                    <tr class="tfoot-services">
                        <th style="width: 25%;">% DSCT</th>
                        <td style="width: 40%;">% nnnnnnnsns {{
                                intval($venta->porcentajeDescuentoRecurrenteAdicional) }} </td>
                        <th style="width: 25%;">TOTAL INCRE.MENSUAL</th>
                        <td style="width: 40%;">{{ $venta->totalRecurrente }} </td>
                    </tr>


                </tfoot>
            </table>

            @endif
        </div>
        <div class="footer">
            <div class="footer-msg-title">
                <h4>Para el descuento otorgado sea válido, el cliente deberá estar al día en sus pagos</h4>
                <h5>Esta cotización tiene una vigencia de 3 meses desde su emisión.</h5>
            </div>
            <br />
            <div class="footer-cotizador">
                <div class="nombre-cotizador">
                    <span><!--{{$venta[0]->nombres}}--></span>
                    <hr>
                    <span>Nombre Cotizador</span>
                </div>
                <div class="firma-cotizador">
                    <span></span>
                    <hr>
                    <span>Firma Cotizador</span>
                </div>
                <div class="autorizacion-cotizador">
                    <span></span>
                    <hr>
                    <span>Firma del cliente o persona autorizada</span>
                </div>
            </div>


            <br />
            <br />
            <br />
            <br />
            <span class="footer-span">Lima: Av. República de Panamá Nº 3890, Telf.: (01) 513­8686 ­ Surquillo /
                Trujillo: Av. Salvador Lara
                Nº 1193­1195 Urb. Miraflores, Telf.: (044) 29­3939 / Arequipa: Ca. María
                Nieves y Bustamante 101 Urb. La Quinta ­ Umacollo, Telf.: (054) 24­7590 Piura: Carretera Piura Sullana
                Km. 3.5, Telf.: (073) 33­3190 ­ Piura / Chiclayo: Block 5A1 Residencial
                Pascual Saco , Telf.: (074) 27­3074
            </span>
        </div>
    </div>
</body>

</html>