import './bootstrap';

import { createApp } from 'vue';
import store from './store'
import router from './routes/index'
import { LoadingPlugin, Loading } from 'vue-loading-overlay';
import VueSweetalert2 from "vue-sweetalert2";
import { Bootstrap5Pagination } from 'laravel-vue-pagination';
import ToastPlugin from 'vue-toast-notification';
import { abilitiesPlugin } from '@casl/vue';
import ability from './services/ability';
import vSelect from "vue-select";
import useAuth from './composables/auth';
import i18n from "./plugins/i18n";

import 'vue-loading-overlay/dist/css/index.css';
import 'sweetalert2/dist/sweetalert2.min.css';
import 'vue-select/dist/vue-select.css';
import 'vue-toast-notification/dist/theme-sugar.css';

const app = createApp({
    created() {
        useAuth().getUser()
    }
});

import ExampleComponent from './components/ExampleComponent.vue';
app.component('example-component', ExampleComponent);
app.component('Loading', Loading);
app.component('v-pagination', Bootstrap5Pagination)
app.component("v-select", vSelect);
app.use(ToastPlugin);
app.use(LoadingPlugin);
app.use(router)
app.use(store)
app.use(VueSweetalert2)
app.use(i18n)
app.use(abilitiesPlugin, ability)
app.mount('#app')
