<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductoDetalle extends Model
{
    use HasFactory;
    protected $table = 'productodetalle';

    protected $fillable = [
        'id',
        'moneda',
        'idProducto',
        'idTipoModalidadProducto',
        'subTotal',
        'igv',
        'precioVenta',
        'fechaCreacion',
        'usuarioModificador',
        'fechaModificacion',
        'estado',
        'usuarioCreador',
    ];

    protected $casts = [
        'subTotal' => 'decimal:2',
        'igv' => 'decimal:2',
        'precioVenta' => 'decimal:2',
    ];

}
