<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\ApiResource;
use App\Http\Resources\ProductoResource;
use App\Models\Producto;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class VentaController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $producto = Producto::all();
        return ApiResource::collection($producto);
    }

    // NUEVO
    public function FnInsertVenta(Request $request)
    {
        $idCliente = $request->input('idCliente');
        $nombreCliente = $request->input('nombreCliente');
        $numeroContrato = $request->input('numeroContrato');
        $estadoVenta = $request->input('estadoVenta');
        $costoInstalacion = $request->input('costoInstalacion');
        $ultimoVenta = $request->input('ultimoVenta');
        $observacion = $request->input('observacion');
        $observacionRechazo = $request->input('observacionRechazo');
        $renovacionContrato = $request->input('renovacionContrato');
        $upgrade = $request->input('upgrade');
        $afiliacionDebito = $request->input('afiliacionDebito');
        $codigoActividad = $request->input('codigoActividad');
        $descripcionActividad = $request->input('descripcionActividad');
        $porcentajeDescuentoRecurrenteAdicional = $request->input('porcentajeDescuentoRecurrenteAdicional');
        $totalRecurrente = $request->input('totalRecurrente');
        $totalVentaNbo2_7000M = $request->input('totalVentaNbo2_7000M');

        $products = DB::select('CALL InsertVenta(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', [
            $observacion,
            $ultimoVenta,
            $numeroContrato,
            $idCliente,
            $nombreCliente,
            $estadoVenta,
            '1',
            $renovacionContrato,
            $observacionRechazo,
            $upgrade,
            $afiliacionDebito,
            $descripcionActividad,
            $codigoActividad,
            $porcentajeDescuentoRecurrenteAdicional,
            $totalRecurrente,
            $costoInstalacion,
            $totalVentaNbo2_7000M
        ]);
        return $products;
    }

    public function FnInsertMassiveVentaDetalle(Request $request)
    {
        $idVenta = $request->input('idVenta');
        $ventaDetalle = $request->input('ventaDetalle');

        foreach ($ventaDetalle as $item) {
            $cantidad = $item['quantity']?? $item['cantidad'];
            $idProductoDetalle = $item['codigoOracle'];
            $tipoActividad = null;
            $subTotal = $item['subTotal'];
            $igv = $item['igv'];
            $precioVenta =  $item['precioVenta'];
            $descuentoProducto =  $item['descuentoProducto'];
            $descuentoRecurrente = $item['descuentoProducto'];
            $comision = 0;
            $idTipoModalidadProducto = $item['idTipoModalidadProducto'];
            $precioUnitario = $item['subTotal'];
            $descuentoAdicional = 0;
            $recurrenteSubTotal = $item['recurrenteSubtotal'];
            $precioVentaRecurrente = $item['precioVentaRecurrente'];

            $products = DB::select('CALL InsertVentaDetalle(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', [
                $idVenta,
                $cantidad,
                $idProductoDetalle,
                $tipoActividad,
                $subTotal,
                $igv,
                $precioVenta,
                1,
                $descuentoProducto,
                $descuentoRecurrente,
                $comision,
                $idTipoModalidadProducto,
                $precioUnitario,
                $descuentoAdicional,
                $recurrenteSubTotal,
                $precioVentaRecurrente
            ]);
        }

        return $idVenta;
    }


    public function FnUpdateInsertMassiveVentaDetalle(Request $request)
    {
        $idVenta = $request->input('idVenta');
        $ventaDetalle = $request->input('ventaDetalle');

        DB::delete('DELETE FROM ventadetalle WHERE idVenta = ?', [$idVenta]);


        foreach ($ventaDetalle as $item) {
            $cantidad = $item['cantidad'] ?? $item['quantity'];
            $idProductoDetalle = $item['codigoOracle'];
            $tipoActividad = null;
            $subTotal = $item['subTotal'];
            $igv = $item['igv'];
            $precioVenta = $item['precioVenta'];
            $descuentoProducto = $item['descuentoProducto'] ?? $item['descuento'];
            $descuentoRecurrente =  $item['recurrenteTotal'] ?? $item['recurrentetotal'];
            $comision = 0;
            $idTipoModalidadProducto = $item['idTipoModalidadProducto'];
            $precioUnitario = 0;
            $descuentoAdicional = 0;
            $recurrenteSubTotal = $item['recurrenteSubtotalForm']?? $item['recurrenteSubTotal'];
            $precioVentaRecurrente = 0;

            $products = DB::select('CALL UpdateInsertVentaDetalle(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)', [
                $idVenta,
                $cantidad,
                $idProductoDetalle,
                $tipoActividad,
                $subTotal,
                $igv,
                $precioVenta,
                1,
                $descuentoProducto,
                $descuentoRecurrente,
                $comision,
                $idTipoModalidadProducto,
                $precioUnitario,
                $descuentoAdicional,
                $recurrenteSubTotal,
                $precioVentaRecurrente
            ]);
        }

        return $idVenta;
    }


    public function FnGetVentaById(Request $request)
    {
        $ventaId = $request->input('ventaId');
        $modalidades = DB::select('CALL SP_GETVENTABYID(?)', [$ventaId]);
        return $modalidades[0];
    }
}
